#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>

using namespace std;

int citiesCount, roadsCount;
int cityFrom, cityTo;

struct Edge {
	int to, flow, capacity;
	Edge * rev;
	
	Edge(int to, int capacity) : to(to), flow(0), capacity(capacity), rev(0) {}
};

typedef vector < vector < Edge * > > edges_t;

Edge * addEdge(edges_t & edges, int from, int to, int capacity) {
	//cout << from << " " << to << endl;
	Edge * fi = new Edge(to, capacity);
	Edge * se = new Edge(from, 0);
	fi->rev = se;
	se->rev = fi;
	edges[from].push_back(fi);
	edges[to].push_back(se);
	return fi;
}

const int MAXN = 1010;

int q[MAXN], cameFrom[MAXN];
bool used[MAXN];
Edge * edgeUsed[MAXN];

int findMaxFlow(edges_t & edges, int vertices, int from, int to) {
	int result = 0;
	
	while(true) {
		int qs = 0, qt = 0;
		q[qt++] = from;
		fill(used, used + vertices, false);
		used[from] = true;
		while(qs != qt) {
			int u = q[qs++];
			for(int i = 0; i < edges[u].size(); i++) {
				Edge * e = edges[u][i];
				if(e->flow < e->capacity && !used[e->to]) {
					used[e->to] = true;
					q[qt++] = e->to;
					cameFrom[e->to] = u;
					edgeUsed[e->to] = e;
				}
			}
		}
		if(!used[to]) break;
		++result;
		int cursor = to;
		while(cursor != from) {
			Edge * e = edgeUsed[cursor];
			e->flow += 1;
			e->rev->flow -= 1;
			cursor = cameFrom[cursor];
		}
	}
	return result;
}

bool canEnlarge(edges_t & edges, int vertices, int from, int to) {
		int qs = 0, qt = 0;
		q[qt++] = from;
		fill(used, used + vertices, false);
		used[from] = true;
		while(qs != qt && !used[to]) {
			int u = q[qs++];
			for(int i = 0; i < edges[u].size(); i++) {
				Edge * e = edges[u][i];
				if(e->flow < e->capacity && !used[e->to]) {
					q[qt++] = e->to;
					used[e->to] = true;
				}
			}
		}
		
		
		return used[to];
}


void solveOne() {
	int totalVertices = citiesCount + 2;
	int flowFrom = citiesCount, flowTo = citiesCount + 1;
	edges_t edges(totalVertices);
	
	addEdge(edges, flowFrom, cityFrom, roadsCount + 1);
	addEdge(edges, cityTo, flowTo, roadsCount + 1);
	typedef pair < int, int > simple_edge_t;
	vector < simple_edge_t > allEdges(roadsCount);
	vector < Edge * > pointers(roadsCount);
	for(int i = 0; i < roadsCount; i++) {
		int u, v;
		cin >> u >> v;
		--u;
		--v;
		allEdges[i] = make_pair(u, v);
		pointers[i] = addEdge(edges, u, v, 1);
	}
	int maxFlow = findMaxFlow(edges, totalVertices, flowFrom, flowTo);
	int canImprove = 0;
	
	for(int i = 0; i < roadsCount; i++) {
		Edge * e = pointers[i];
		if(e->flow == 0) {
			e->capacity = 0;
			e->rev->capacity = 1;
			if(canEnlarge(edges, totalVertices, flowFrom, flowTo)) {
				++canImprove;
			}
			e->capacity = 1;
			e->rev->capacity = 0;
		}
	}
	
	if(canImprove != 0)
		++maxFlow;
	
	cout << maxFlow << " " << canImprove << "\n";
}

int main() {
	ios_base::sync_with_stdio(false);
	while(true) {
		cin >> citiesCount >> roadsCount >> cityFrom >> cityTo;
		--cityFrom; --cityTo;
		if(citiesCount == 0)
			break;
		solveOne();
	}
	return 0;
}